<?php
namespace app\admin\controller;
use think\App;
use think\facade\Session;
use think\facade\View;
use think\facade\Request;
 
class cate extends Base{

    public function index(){
		$list=\app\admin\model\Cate::order('sort asc')->select()->toArray();
		$list = cate_list($list);
		
		$model_list=\app\admin\model\CateType::field('name')->select()->toArray();
		$pid_array=array_column($list,'pid');
		foreach($list as $k=>$c){
			if(inarray($c['id'],$pid_array)==1){
			$list[$k]['is_xj']=1;
			}
			$list[$k]['model_name']=$model_list[$c['model_id']-1]['name'];
		}		
		
		View::assign(['list'=>$list]);
		return View::fetch();
    }
	
    public function list_data(){
		IS_AJAX(Request::isAjax());
		$list=\app\admin\model\Cate::order('sort asc')->select()->toArray();
		$list = cate_list($list);
		foreach($list as $k=>$c){
			$typename=\app\admin\model\CateType::where('id',$c['model_id'])->field('name')->find();
			$list[$k]['typename']=$typename['name'];
		}
		
		$data['code']=0;
		$data['data']=$list;
		return json($data);
    }

    public function add(){
		$list=\app\admin\model\Cate::order('sort asc')->select()->toArray();
		$list = cate_list($list);
		$pid=Request::param('pid');
		$cate_type_list=\app\admin\model\CateType::order('id asc')->select()->toArray();

		View::assign(['list'=>$list,'pid'=>$pid,'cate_type_list'=>$cate_type_list]);
		return View::fetch();
    }
	
    public function insert(){
		IS_AJAX(Request::isAjax());
		$tdata=Request::param();
		if($tdata['catename']==''){
			$data =['type' =>2,'msg' =>'栏目名称不能为空'];
			return json($data);
		}

		if($tdata['link']==3 and $tdata['link_url']==''){
			$data =['type' =>2,'msg' =>'请填写链接地址'];
			return json($data);
		}

		$map['pid']=$tdata['pid'];
		$info=\app\admin\model\Cate::where($map)->field('sort')->order('sort desc')->find();
		$tdata['sort']=$info['sort']+1;
		
		//判断seo是否被占用
		if($tdata['cateseo']!=''){
			$cateseo=\app\admin\model\Cate::where('cateseo',$tdata['cateseo'])->value('id');
			if($cateseo!=''){
				$data =['type' =>2,'msg' =>'栏目目录已存在'];
				return json($data);
			}
		}
		
		//去掉seo空格
		$tdata['cateseo']=str_replace(' ','',$tdata['cateseo']);
		$id=\app\admin\model\Cate::insertGetId($tdata);
		
		//更新伪静态文件
		if($tdata['cateseo']!=''){
			$this->cateseo();
		}
		
		//添加日志
		$log=\app\admin\model\Log::insert('新增栏目内容:数据ID='.$id.'');
		
		$data =['type' =>1,'msg' =>'添加成功'];
		return json($data);
    }

    public function edit(){
		$id=Request::param('id');
		$list=\app\admin\model\Cate::where('id','<>',$id)->order('sort asc')->select()->toArray();
		$list = cate_list($list);
				
		$info=\app\admin\model\Cate::find($id);

		$cate_type_list=\app\admin\model\CateType::order('id asc')->select()->toArray();
		
		$map['is_effect']=1;
		$map['pid']=$id;
		$cate_pid_list=\app\admin\model\Cate::where($map)->field('id,catename')->order('sort asc')->select();
		
		View::assign(['list'=>$list,'info'=>$info,'cate_type_list'=>$cate_type_list,'cate_pid_list'=>$cate_pid_list]);
		return View::fetch();
    }

    public function update(){
		$tdata=Request::param();
		if($tdata['catename']==''){
			$data =['type' =>2,'msg' =>'栏目名称不能为空'];
			return json($data);
		}
		
		if($tdata['link']==3 and $tdata['link_url']==''){
			$data =['type' =>2,'msg' =>'请填写链接地址'];
			return json($data);
		}

		//判断seo是否被占用
		if($tdata['cateseo']!=''){
			$cateseo=\app\admin\model\Cate::where('cateseo',$tdata['cateseo'])->value('id');
			if($cateseo!='' and $cateseo!=$tdata['id']){
				$data =['type' =>2,'msg' =>'栏目目录已存在'];
				return json($data);
			}
		}
		
		//去掉seo空格
		$tdata['cateseo']=str_replace(' ','',$tdata['cateseo']);
		$id=\app\admin\model\Cate::update($tdata);
		
		//更新伪静态文件
		if($tdata['cateseo']!='' and $cateseo!=$tdata['id']){
			$this->cateseo();
		}

		//添加日志
		$log=\app\admin\model\Log::insert('修改栏目内容:数据ID='.$tdata['id'].'');

		$data =['type' =>1,'msg' =>'修改成功'];
		return json($data);
    }

    public function cateseo(){
		$hj=TQ('SYSTEM_TYPE');
		$list=\app\admin\model\Cate::where('cateseo','<>','')->order('sort asc')->select()->toArray();
		//Apache
		if($hj==1){
			$content[]="<IfModule mod_rewrite.c>";
			$content[]="\n";
			$content[]="RewriteEngine on";
			$content[]="\n";
			$content[]="Options +FollowSymlinks";
			//$content[]="\n";
			//$content[]="RewriteRule ^$ index.php [L]";
	
			//动态部分开始
			foreach($list as $k=>$c){
				$content[]="\n";
				$content[]="RewriteRule ^".$c['cateseo'].".html$ /index/Lists/index/id/".$c['id']." [L]";
				$content[]="\n";
				$content[]="RewriteRule ^".$c['cateseo']."/([0-9]+).html$ /index/Lists/index/id/$1 [L]";
				$content[]="\n";
				$content[]="RewriteRule ^".$c['cateseo']."/([0-9]+)/([0-9]+).html$ /index/Lists/index/id/$1/page/$2 [L]";
				$content[]="\n";
				$content[]="RewriteRule ^".$c['cateseo']."/([0-9]+)/([0-9]+)/(.+).html$ /index/Lists/index/id/$1/page/$2/v/$3 [L]";
				$content[]="\n";
				$content[]="RewriteRule ^".$c['cateseo']."/view/([0-9]+).html$ /index/Details/index/id/$1 [L]";
			}
					
			//动态部分结束
			
			$content[]="\n";
			$content[]="RewriteRule ^Search.html$ /index/Index/search [L]";
			$content[]="\n";
			$content[]="RewriteRule ^user.html$ /index/User/index [L]";
			$content[]="\n";
			$content[]="RewriteRule ^login.html$ /index/User/login [L]";
			$content[]="\n";
			$content[]="RewriteRule ^reg.html$ /index/User/reg [L]";
			$content[]="\n";
			$content[]="RewriteRule ^out.html$ /index/User/out [L]";
			$content[]="\n";
			$content[]="RewriteRule ^password.html$ /index/User/password [L]";
			$content[]="\n";
			$content[]="RewriteRule ^works.html$ /index/User/works [L]";
			$content[]="\n";
			$content[]="RewriteRule ^add.html$ /index/User/add [L]";
			$content[]="\n";
			$content[]="RewriteRule ^PreviousWorks.html$ /index/User/pworks [L]";
			$content[]="\n";
			$content[]="RewriteRule ^PreviousWorks/([0-9]+).html$ /index/User/pworks/id/$1 [L]";
			$content[]="\n";
			$content[]="RewriteRule ^PreviousWorks/([0-9]+)/([0-9]+).html$ /index/User/pworks/id/$1/page/$2 [L]";
			$content[]="\n";
			$content[]="RewriteRule ^PreviousWorks/view/([0-9]+).html$ /index/User/view/id/$1 [L]";
			$content[]="\n";
			$content[]="RewriteRule ^back.html$ /index/User/back [L]";
			$content[]="\n";
			$content[]="RewriteRule ^edit.html$ /index/User/edit [L]";
			
			$content[]="\n";
			$content[]="RewriteCond %{REQUEST_FILENAME} !-d";
			$content[]="\n";
			$content[]="RewriteCond %{REQUEST_FILENAME} !-f";
			$content[]="\n";
			$content[]="RewriteRule ^(.*)$ index.php?s=$1 [QSA,PT,L]";
			$content[]="\n";
			$content[]="</IfModule>";
	
			file_put_contents(".htaccess",$content);
		}
		//Nginx
		if($hj==2){
			$content[]="location / {";
			$content[]="\n";
			$content[]="rewrite ^/$ /index.php last;";
			$content[]="\n";
			//动态部分开始
			foreach($list as $k=>$c){
				$content[]="rewrite ^/".$c['cateseo'].".html$ /index/Lists/index/id/".$c['id']." last;";
				$content[]="\n";
				$content[]="rewrite ^/".$c['cateseo']."/([0-9]+).html$ /index/Lists/index/id/$1 last;";
				$content[]="\n";
				$content[]="rewrite ^/".$c['cateseo']."/([0-9]+)/([0-9]+).html$ /index/Lists/index/id/$1/page/$2 last;";
				$content[]="\n";
				$content[]="rewrite ^/".$c['cateseo']."/([0-9]+)/([0-9]+)/(.+).html$ /index/Lists/index/id/$1/page/$2/v/$3 last;";
				$content[]="\n";
				$content[]="rewrite ^/".$c['cateseo']."/view/([0-9]+).html$ /index/Details/index/id/$1 last;";
				$content[]="\n";
			}

			$content[]="rewrite ^/Search.html$ /index/Index/search last;";
			$content[]="\n";
			$content[]="if (!-e \$request_filename) {";
			$content[]="\n";
			$content[]="rewrite ^/(.*)$ /index.php?s=$1 last;";
			$content[]="\n";
			$content[]="}";
			$content[]="\n";
			$content[]="}";
			file_put_contents("nginx.htaccess",$content);
		}


	}

}
