<?php
namespace app\admin\controller;
use think\App;
use think\facade\Db;
use think\facade\Session;
use think\facade\View;
use think\facade\Request;
 
class Tablefield extends Base{

    public function index(){
		
		$table_list=Db::getTables();
		$table_list = array_diff($table_list,['tq_cate_type','tq_images_type']);

		//新增表需修改
		foreach($table_list as $k=>$v){
			if (strpos($v,'_cate_')!==false or strpos($v,'_article_')!==false or strpos($v,'_images')!==false) {
				$list[$k]['pid']=$v;
				$list[$k]['table']=$this->table_true($v);
				$list[$k]['name']=$this->table_name($v);
			}
		}
		sort($list);
		
		View::assign([
			'table_list'=>$list,
		]);
		return View::fetch();
    }

	public function add(){
		$tdata=Request::param();
		$field_list=config('common.FIELD_LIST');
		
		View::assign(['table_name'=>$tdata['table_name'],'pid'=>$tdata['pid'],'field_list'=>$field_list]);
		return View::fetch();
    }


    public function insert(){
		IS_AJAX(Request::isAjax());
		$tdata=Request::param();
		if($tdata['field_cn_name']==''){
			$data =['type' =>2,'msg' =>'中文名称不能为空'];
			return json($data);
		}
		
		if($tdata['field_name']==''){
			$data =['type' =>2,'msg' =>'字段名称不能为空'];
			return json($data);
		}
		
		$field_where['pid']=$tdata['pid'];
		$field_where['field_name']=$tdata['field_name'];
		$field=\app\admin\model\TableField::where($field_where)->limit(1)->select();
		if(isset($field[0])){
			$data =['type' =>2,'msg' =>'该字段已添加'];
			return json($data);
		}
		
		$sort=\app\admin\model\TableField::where('pid',$tdata['pid'])->order('sort desc')->limit(1)->select();
		if(isset($sort[0])){
			$tdata['sort']=$sort[0]['sort']+1;
		}else{
			$tdata['sort']=1;
		}
		
		//插入字段
		$add_field=\app\admin\model\TableField::field_add();
		
		$id=\app\admin\model\TableField::insert($tdata);
		$data =['type' =>1,'msg' =>'添加成功'];
		return json($data);
    }

	public function table_true($table){
		$arr=explode('_',$table);
		foreach($arr as $k=>$c){
			if($c!='tq'){
				$new_arr[$k]=ucfirst($c);
			}
		}
		$table=implode('',$new_arr);
		return $table;
	}
	
    public function table_name($table){
		$table_name=[
			'tq_cate'         =>'Cate栏目主表',
			'tq_cate_content' =>'CateContent栏目扩展表',
			'tq_article'      =>'Article文章主表',
			'tq_article_article'      =>'ArticleArticle文章扩展表',
			'tq_images'      =>'Images广告位',
		];
		if(isset($table_name[$table])){
			return $table_name[$table];
		}else{
			$table=explode('_',$table);
			$cate_info=\app\admin\model\CateType::where('table',$table[2])->find();
			if(isset($table[2])){
				return 'Article'.ucfirst($table[2]).$cate_info['name'].'扩展表';
			}else{
				return 'xxx扩展表';
			}
		}
	}

	public function is_delete(){
		$tdata=Request::param();
		//删除字段
		$field_delete=\app\admin\model\TableField::field_delete();
		
		$id=\app\admin\model\TableField::where('id',$tdata['id'])->delete();
		$data =['type' =>1,'sss'=>$tdata,'msg' =>'删除成功'];
		return json($data);
	}
	
	
	public function list_data(){
		//IS_AJAX(Request::isAjax());
		$tdata=Request::param();
		
		$list=\app\admin\model\TableField::where('table',$tdata['table'])->order('sort asc')->select()->toArray();
		$data['code']=0;
		$data['data']=$list;
		
		return json($data);
    }

	
}
