<?php
namespace app\admin\model;
use think\Model;

// 引入框架内置类
use think\facade\Db;
use think\facade\Event;
use think\facade\Session;
use think\facade\Request;

class Admin extends Model{
	
    // 定义时间戳字段名
    protected $createTime = 'time';
    protected $updateTime = 'login_time';
	protected $dateFormat = 'Y-m-d';

	//登录验证
    public static function checkLogin($name,$pwd){
		$pwd=pass_encrypt($pwd);
		$map[] = ['name','=',$name];
		$map[] = ['password','=',$pwd];
		$info=Admin::where($map)->find();
        return $info;
    }

	//管理员账号信息列表
    public static function admin_list(){
		//$list_rows=request()->param('limit');
		$list_rows=100;
		$list = Admin::alias('a')->join('auth_group g', 'a.auth_id=g.id', 'left')->field('a.*,g.name,a.name aname')->order('a.id asc')->paginate(['list_rows' =>$list_rows,'query' => request()->param(),]);
        return $list;
    }

	//管理员账号信息
    public static function admin_info($t,$val){
		if($t==1){ $map['id']=$val; }
		if($t==2){ $map['name']="".$val.""; }
		$info=Admin::where($map)->withoutField('password')->find();
        return $info;
    }


	//管理员添加修改
    public static function admin_save($tdata){
		if($tdata['password']!=''){
			$tdata['password']=pass_encrypt($tdata['password']);
		}else{
			unset($tdata['password']);
		}
		$tdata['time']=time();
		
		unset($tdata['pwd']);
		if(isset($tdata['id'])){
			Db::name('admin')->save($tdata);
			$id=$tdata['id'];
		}else{
			$id=Db::name('admin')->insertGetId($tdata);
		}
        return $id;
    }
	
	//管理员edit
    public static function edit(){
		$tdata=Request::param();
		$info=Admin::withoutField('password,login_time,time')->find($tdata['id']);
		$info=$info->toArray();
        return $info;
    }


}