<?php
namespace app\admin\model;
use think\Model;

// 引入框架内置类
use think\facade\Db;
use think\facade\Event;
use think\facade\Session;
use think\facade\Request;

class Form extends Model{
	
    // 定义时间戳字段名
    protected $createTime = 'create_time';
    protected $updateTime = 'update_time';

	
	//获取数据
    public static function list_data($limit){
		$tdata=Request::param();
		$table=tq_value($tdata['pid'],'table','form_type');
		
		if(!empty($tdata['strtime'])){
			$map[] = ['create_time','>=', strtotime($tdata['strtime'])];
		}
		if(!empty($tdata['endtime'])){
			$map[] = ['create_time','<=', strtotime($tdata['endtime'])];
		}
		if(!empty($tdata['keyword'])){
			$map[] = ['phone','like',"%".$tdata['keyword']."%"];
		}

		$map[]=['id','<>',''];
		$list=Db::name($table)->where([$map])->order('create_time desc')->paginate(['list_rows' =>$limit,'query' => request()->param(),])->toArray();
		return $list;
	}

	//获取数据
    public static function field($field,$table){
		$table='tq_'.$table;
		$sql = "show full columns from {$table}";
        $res = Db::query($sql);
		foreach($res as $k=>$c){
			if($c['Field']!=$field){
				unset($res[$k]);
			}
		}
		$res=array_column($res, 'Comment');
		return $res[0];
	}

	//form查看页
    public static function form_view($table){
		$table='tq_'.$table;
		$dbname=env('DATABASE_DATABASE');
		$sql = "show full columns from {$table}";
        $res = Db::query($sql);
		foreach($res as $k=>$c){
			if($c['Field']=='id'){ unset($res[$k]); }
			if($c['Field']=='userid'){ unset($res[$k]); }//个列使用
			if($c['Field']=='is_all'){ unset($res[$k]); }//个列使用

			if($c['Field']=='is_effect'){ unset($res[$k]); }
			if($c['Field']=='content'){ unset($res[$k]); }
			if($c['Field']=='create_time'){ unset($res[$k]); }
		}

		return $res;
	}

	//查看留言
    public static function info($id,$table,$pid){
		$type=Db::name('form_type')->where('id',$pid)->value('title');
		$info=Db::name($table)->find($id);
		$info['form_type']=$type;
		return $info;
	}

	//修改留言
    public static function update_content($tdata){
		$name=$tdata['table'];
		$info=Db::name($name)->strict(false)->update($tdata);
		return $tdata;
	}
	
}