<?php
//管理员列表验证器
namespace app\admin\validate;
use think\Validate;

class Admin extends Validate{
	
	protected $rule=[
		//'is_super'   => ['neq:2'],
		'is_info'   => 'is_auto:1',
		'name' => ['require','length'=>'6,10','regex' => '/^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]+$/'],
		'are' =>'are',
	];

	protected $message=[
		//'is_super' => '无权限',
		'is_info' => '账号已存在',
		'name.require'=>'账号不能为空',
		'name.length' => '账号必须6-10个字符',
		'name.regex' => '账号必须是字母和数字的组合',
	];

	// 自定义验证规则
    protected function is_auto($value,$rule, $data=[]){
		if($value>0 and $rule==1){ return '账号已存在'; }
    }

    protected function are($v,$r, $d=[]){
		$rule1 = '/^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]+$/';
        $msg1 =preg_match($rule1,$d['password']);//密码必须是字母和数字的组合
		$rule2='/^[.]{6,16}$/';
		$msg2 =strlen($d['password']);
		
		if($d['are']==0 and $d['password']==''){
			return '密码不能为空';
		}
		
		if($d['password']){
			if($msg1==0){
				return '密码必须是字母和数字的组合';
			}
			if($msg2<6){
				return '密码必须6-10个字符';
			}
			if($d['password']!=$d['pwd']){
				return '密码不一致';
			}
		}
		
		return true;
    }
		
}