<?php
error_reporting(E_ERROR | E_PARSE );//未定义变量处理报错

//C1 导航栏目 type:1为顶部导航 2为底部导航默认为1 limit:默认为10
function menu($type='',$limit=10){
	$list=\app\index\model\CateContent::get_menu($type,$limit);
	foreach($list as $k=>$v){
		$list[$k]['url']=seo_url($v);
		$list[$k]['is_new']=$v['is_new']==1?'target=_blank':'';
	}
	return $list;
}

//C2 导航二级菜单 $pid上级id $is_down:是否显示在下拉菜单1为是 $limit:数量 $where
function menu_cate($pid,$limit=10){
	$list=\app\index\model\CateContent::menu_cate($pid,$limit);
	foreach($list as $k=>$v){
		$list[$k]['url']=seo_url($v);
		$list[$k]['is_new']=$v['is_new']==1?'target=_blank':'';
	}
	return $list;
}

//C3 获取栏目信息详情
function cate($id,$field='catename'){
	$info=\app\index\model\CateContent::info($id);
	if($field==''){
		return $info;
	}else{
		if($field=='url'){
			return seo_url($info);
		}else{
			return $info[$field];
		}
	}
}

//C4 获取栏目列表
function cates($pid,$limit=10){
	$list=\app\index\model\CateContent::cate_list($pid,$limit);
	foreach($list as $k=>$v){
		$list[$k]['url']=seo_url($v);
	}
	return $list;
}

//C5 获取文章列表
function article($id='',$limit='',$mx=2,$att='',$where=''){
	$list=\app\index\model\Lists::list_article($id,$limit,$mx,$att);
	return $list;
}

//C6 banner图类(当前栏目无查找父类)
function banner($field,$id=''){
	if($id==''){
		$id=now_id();
	}
	$id_array=get_index_cate_id_parents($id);
	
	//没有的栏目,错误填写。
	if(empty($id_array)){
		$value='';
	}else{
		foreach($id_array as $k=>$c){
			$info=\app\index\model\CateContent::info($c);
			if($info[$field]==''){
				$value='';
			}else{
				$value=$info[$field];break;
			}
		}
	}
	
	return $value;
}

//C7 获取上级id_array
function F($id=''){
	if($id==''){
		$id=now_id();
	}
	$F=arr_sort(get_index_cate_id_parents($id));
	return $F;
}

//C8 获取栏目和文章组合字段信息
function field($field,$limit=999){
	$map[] = ['pid','=',$field];
	$list=\app\admin\model\Field::where($map)->order('sort asc')->limit($limit)->select();
	return $list;
}

//C9 幻灯片,友情链接等列表信息
function ads_list($pid,$limit='10'){
	$map[] = ['is_effect','=',1];
	$map[] = ['pid','=',$pid];
	$list=\app\admin\model\Images::where($map)->order('sort asc')->limit($limit)->select();
	foreach($list as $k=>$c){
		$list[$k]['is_new']=$c['is_new']==1?'':'target=_blank';
	}
	return $list;
}

//C10 获取当前位置
function location($t=''){
	$id=now_id();
	$id_array=arr_sort(get_index_cate_id_parents($id));
	if($t==''){
		$fen="&nbsp;&gt;&nbsp;";
	}else{
		$fen=$t;
	}
	
	foreach($id_array as $k=>$c){
		$info=\app\index\model\CateContent::info($c);
		if($k!=0){ $content[]=$fen; }
		$content[]="<a href=\"".seo_url($info)."\">".$info['catename']."</a>";
	}
	
	$info=implode($content);
	return $info;
}

//C11 时间组合信息
function t($time,$t=1,$f="-"){
	if($t==1){ $type="Y".$f."m".$f."d"; }
	if($t=='ymdhis'){ $type="Y".$f."m".$f."d H:i:s"; }
	if($t=='y'){ $type="Y"; }
	if($t=='m'){ $type="m"; }
	if($t=='d'){ $type="d"; }
	if($t=='ym'){ $type="Y".$f."m"; }
	if($t=='md'){ $type="m".$f."d"; }
	$time=date($type,$time);
	return $time;
}

//C12 详情页文章上一条下一条
function page($type,$field,$content='没有了!'){
	$id      =Request()->param('id');
	$sort    =tq_value($id,'sort','article');
	$pid     =tq_value($id,'pid','article');
	$is_sort =tq_value($pid,'is_sort','cate');
	
	$map[] = ['is_effect','=',1];
	$map[] = ['is_delete','=',1];
	$map[] = ['pid','=',$pid];

	if(($is_sort=='desc' and $type==1) or ($is_sort=='asc' and $type==2)){
		$map[] = ['sort','>',$sort];
		$order='asc';
	}
	if(($is_sort=='desc' and $type==2) or ($is_sort=='asc' and $type==1)){
		$map[] = ['sort','<',$sort];
		$order='desc';
	}
	
	$list=\app\admin\model\Article::where($map)->order('sort '.$order.'')->limit(1)->field('id,pid,title,sort')->select();
	if($field==1){
		if($list->isEmpty()){
			$return=$content;
		}else{
			$return=$list[0]['title'];
		}
	}
	if($field==2){
		if($list->isEmpty()){
			$return='javascript:';
		}else{
			$return=info_seo_url($list[0]['pid'],$list[0]['id']);
		}
	}
	
	return $return;
}

//Z1 增加文章点击量
function article_ck(){
	$c=Request()->controller(); //获取控制器名,根据控制器名判定
	if($c=='Details'){
		$id=Request()->param('id');
		$list=\app\index\model\Details::article_ck($id);
	}
}

//Z2 是否首页
function is_home(){
	$c=Request()->controller(); //获取控制器名
	$a=Request()->action(); //获取方法名
	if($c=='Index' and $a=='index'){
		return 1;
	}else{
		return 2;
	}
}

//Z3 是否当前栏目
function is_this($tsid){
	$c=Request()->controller(); //获取控制器名
	$p=Request()->param(); //获取控制器名
	if($c=='Lists'){
		$arr=arr_sort(get_index_cate_id_parents($p['id']));
		$p=inarray($tsid,$arr);
	}
	if($c=='Details'){
		$pid=tq_value($p['id'],'pid','article');
		$arr=arr_sort(get_index_cate_id_parents($pid));
		$p=inarray($tsid,$arr);
	}
	if($c=='Lists' or $c=='Details'){
		return $p;
	}else{
		return 0;
	}
}

//Z4 无图片添加默认图片
function no_pic($pic){
	if($pic==''){
		$pic=tq_value(1,'pic','system');
	}	
	return $pic;
}

//Z5 top_seo 网站顶部优化
function web_system(){
	$info=\app\admin\model\System::where('id',1)->find();
	return $info;
}

//Z6 多行文本框换行输出
function hang($value){
	$value=nl2br($value);
	$new_value=str_replace('\n','',$value);
	return $new_value;	
}

//Z7 给表ID重置为从1开始
function table_id($table){
	$list=\app\index\model\Common::table_id($table);
	return 'ok';
}

//获取当前栏目(cate表)ID,用于列表页和详情页。
function now_id(){
	$c=Request()->controller(); //获取控制器名,根据控制器名判定
	if($c=='Lists'){
		$id=Request()->param('id');
	}else if($c=='Details'){
		$id=Request()->param('id');
		$id=tq_value($id,'pid','Article');
	}else{
		$id='';
	}
	return $id;
}

//栏目链接url
function seo_url($info){
	//本栏目
	if($info['link']==1){
		if($info['cateseo']!=''){
			$url='/'.$info['cateseo'].'.html';
		}else if($info['model_id']==1 and $info['cateseo']==''){
			$url=url('index/Lists/index',array('id'=>$info['id']))->build();
		}else{
			$parents_id=get_index_cate_id_parents($info['id']);
			//rsort($parents_id); 顺序待查
			foreach($parents_id as $k=>$c){
				$value=tq_value($c,'cateseo','cate');
				if($value!=''){
					$url='/'.$value.'/'.$info['id'].'.html';
					break;
				}else{
					$url=url('index/Lists/index',array('id'=>$info['id']))->build();	
				}
			}
		}
	}
	
	//子栏目
	if($info['link']==2){
		$infoz=\app\admin\model\Cate::find($info['link_rel'])->toArray();
		$url=seo_url($infoz);
	}
	
	//外链
	if($info['link']==3){
		$url=$info['link_url'];	
	}

	return $url;
}

//获取当前ID的父级id_array
function get_index_cate_id_parents($pid,$k=''){
	$array=\app\admin\model\Cate::where('id',$pid)->field('id,catename,pid,model_id')->find();
	$arr = array();
	if($k==''){ $arr[]=intval($pid); }//获取父栏目的时候加上本栏目
	if($array[pid]>0){
	$arr[] = $array['pid'];
	$arr = array_merge($arr,get_index_cate_id_parents($array['pid'],1));
	}
	return $arr;
}

//父级array 倒着排序
function arr_sort($arr){
	return array_reverse($arr);
}

//获取当前栏目所有子栏目id_array
function get_index_cate_id_son($id,$k=''){
	$array=\app\admin\model\Cate::where('pid',$id)->field('id,catename,pid,model_id')->select()->toArray();
	$arr = array();
	if($k==''){ $arr[]=intval($id); }//获取子栏目的时候加上本栏目
	foreach($array as $v){
		if($v['pid'] == $id){
			$arr[] = $v['id'];
			$arr = array_merge($arr,get_index_cate_id_son($v['id'],1));
		};
	};
	return $arr;
}

//去除不是相同模型的栏目,用于:1.lists页面获取所有相同模型的下级栏目数据
function get_index_id_array_filter($array,$model_id){
	$list=\app\admin\model\Cate::where('id','in',$array)->field('id,model_id')->select()->toArray();
	$arr = array();
	foreach($list as $k=>$v){
		if($v['model_id']==$model_id){
			$arr[] = $v['id'];
		}
	}
	return $arr;
}

//详情页链接 SEO优化
function info_seo_url($pid,$id){
	$info=\app\admin\model\Cate::find($pid);
	if($info['cateseo']!=''){
		$url='/'.$info['cateseo'].'/view/'.$id.'.html';
	}else{
		$parents_id=get_index_cate_id_parents($info['id']);
		//rsort($parents_id);
		foreach($parents_id as $k=>$c){
			$value=tq_value($c,'cateseo','cate');
			if($value!=''){
				$url='/'.$value.'/view/'.$id.'.html';
				break;
			}else{
				$url=url('index/Details/index',array('id'=>$id))->build();
			}
		}
	}
	return $url;
}

//cate栏目的上一条下一条
function cate_page($pid,$id){
	$list=\app\admin\model\Cate::where('pid',$pid)->field('id,pid,catename,model_id,cateseo,link')->limit(9999)->select()->toArray();
	foreach($list as $k=>$c){
		$list[$k]['url']=seo_url($c);
		if($c['id']==$id){
			$thisk=$k;
		}
	}
	
	$data[0]['url']=$list[$thisk-1]['url'];
	$data[0]['catename']=$list[$thisk-1]['catename'];
	$data[1]['url']=$list[$thisk+1]['url'];
	$data[1]['catename']=$list[$thisk+1]['catename'];
	if($data[0]['url']==''){
		$data[0]['url']='#this';
		$data[0]['catename']='没有了!';		
	}
	if($data[1]['url']==''){
		$data[1]['url']='#this';
		$data[1]['catename']='没有了!';		
	}
	
	return $data;
}

//通过表、ID获取内容
function get_name($id,$field,$table){
	$name=\app\admin\model\Common::tq_value($id,$field,$table);
	return $name;
}

//数字*号显示
function code_x($code,$a=3,$b=7){
    for($i=1;$i<=$b-$a;$i++){
        $ss[]='*';
    }
    $xx=implode('',$ss);
    if($code){
        $code=substr($code,0,$a).$xx.substr($code,$b);
    }
    return $code;
}