<?php
declare (strict_types = 1);
namespace app\index\controller;
use think\App;

abstract class Base
{
    protected $appName;        //当前应用名称
    protected $controllerName; //获取当前的控制器名
    protected $public;         //公共目录
    protected $template;       //模板目录
    protected $system;         //系统信息

    public function __construct(App $app){
        $this->app     = $app;
        $this->request = $this->app->request;

        // 控制器初始化
        $this->initialize();
    }

    // 初始化
    protected function initialize(){
		$system=\app\admin\model\System::find(1);
		$this->$system=$system;
    }

}
