<?php
namespace app\index\controller;
use think\facade\Request;

class Upload extends Base{
	
	public function upload(){

		$file = request()->file('file');
		$fileName=$file->getOriginalName();//文件原名称
		$fileExt='.'.$file->getOriginalExtension();//后缀
		
		try {
			// 使用验证器验证上传的文件
			validate([
					'file' => [
						// 限制文件大小(单位b)，这里限制为4M
						'fileSize' => 10*1024*1024,
						// 限制文件后缀，多个后缀以英文逗号分割
						'fileExt'  => 'gif,jpg,png'
					]],
					[
					'file.fileSize' => '文件大小超出限制',
					'file.fileExt'  => '不支持的文件后缀',
					]
			)->check(['file' => $file]);
			
			$name=date('Ymd').time().mt_rand(10,99).$fileExt;//自定义图片名称
			$saveName = \think\facade\Filesystem::disk('public')->putFileAs('images',$file,$name);
			$path = \think\Facade\Filesystem::getDiskConfig('public', 'url').'/'.str_replace('\\','/',$saveName);//完整地址用于调用
			$data =['type' =>1,'file'=>$path,'info' =>'上传成功'];
	
		} catch (\think\exception\ValidateException $e) {
			$msg=$e->getMessage();
			$data =['type' =>2,'info' =>$msg];
		}
		
		return json($data);
    }

	public function upload_file(){

		$file = request()->file('file');
		$fileName=$file->getOriginalName();//文件原名称
		$fileExt='.'.$file->getOriginalExtension();//后缀
		
		try {
			// 使用验证器验证上传的文件
			validate([
					'file' => [
						// 限制文件大小(单位b)，这里限制为400M
						'fileSize' => 400*1024*1024,
						// 限制文件后缀，多个后缀以英文逗号分割
						'fileExt'  => 'zip,pdf,ppt,mp3,mp4,mov,doc,xlsx,xls,docx'
					]],
					[
					'file.fileSize' => '文件大小超出限制',
					'file.fileExt'  => '不支持的文件后缀',
					]
			)->check(['file' => $file]);
			
			$name=date('Ymd').time().mt_rand(10,99).$fileExt;//自定义图片名称
			$saveName = \think\facade\Filesystem::disk('public')->putFileAs('file',$file,$name);
			$path = \think\Facade\Filesystem::getDiskConfig('public', 'url').'/'.str_replace('\\','/',$saveName);//完整地址用于调用
			$data =['type' =>1,'file'=>$path,'info' =>'上传成功'];
	
		} catch (\think\exception\ValidateException $e) {
			$msg=$e->getMessage();
			$data =['type' =>2,'info' =>$msg];
		}
		
		return json($data);
    }

	public function index_file(){
		$file = request()->file('file');
		$fileName=$file->getOriginalName();//文件原名称
		$fileExt='.'.$file->getOriginalExtension();//后缀
		
		try {
			// 使用验证器验证上传的文件
			validate([
					'file' => [
						// 限制文件大小(单位b)，这里限制为4M
						'fileSize' => 400*1024*1024,
						// 限制文件后缀，多个后缀以英文逗号分割
						'fileExt'  => 'doc,docx,ppt,pptx,pdf'
					]],
					[
					'file.fileSize' => '文件大小超出限制',
					'file.fileExt'  => '不支持的文件后缀',
					]
			)->check(['file' => $file]);
			
			$name=date('Ymd').time().mt_rand(10,99).$fileExt;//自定义图片名称
			$saveName = \think\facade\Filesystem::disk('public')->putFileAs('file',$file,$name);
			$path = \think\Facade\Filesystem::getDiskConfig('public', 'url').'/'.str_replace('\\','/',$saveName);//完整地址用于调用
			$data =['type' =>1,'file'=>$path,'info' =>'上传成功'];
	
		} catch (\think\exception\ValidateException $e) {
			$msg=$e->getMessage();
			$data =['type' =>2,'info' =>$msg];
		}
		return json($data);
    }
	
}
