<?php
namespace app\index\controller;
use think\facade\View;
use think\facade\Request;
use think\facade\Session;

class User extends Base{
	
    public function index(){
		$USER_ID=Session::get('USER_ID');
		if($USER_ID==''){ return redirect('/login.html'); }
		$info=\app\index\model\User::withoutField('password,is_effect,content,time')->find($USER_ID);
		View::assign(['info'=>$info,'NOW'=>1]);
		return View::fetch();
    }

    public function login(){
		return View::fetch();
    }	

    public function reg(){
		return View::fetch();
    }

    public function back(){

		View::assign(['NOW'=>2]);
		return View::fetch();
    }
	
    public function password(){
		$USER_ID=Session::get('USER_ID');
		if($USER_ID==''){ return redirect('/login.html'); }
		$info=\app\index\model\User::withoutField('password,is_effect,content,time')->find($USER_ID);
		View::assign(['info'=>$info,'NOW'=>2]);
		return View::fetch();
    }

    public function edit(){
		$tdata=Request::param();
        $USER_ID=Session::get('USER_ID');
        if($USER_ID==''){ return redirect('/login.html'); }
		View::assign(['NOW'=>4]);
		return View::fetch();
    }
	
	//登录操作		
    public function do_login(){
		IS_AJAX(Request::isAjax());
		$tdata=Request::param();

		if(trim($tdata['name'])==''){
			$data =['type' =>1,'msg' =>'请填写用户名!'];
			return json($data);
		}
		
		if(trim($tdata['password'])==''){
			$data =['type' =>1,'msg' =>'请填写密码!'];
			return json($data);
		}	
		
		$sms_rand =Session::get('sms_rand');
		if(trim($tdata['code'])!=$sms_rand or trim($tdata['code'])==''){
			$data =['type' =>1,'msg' =>'短信验证码错误!'];
			return json($data);
		}
		
		$map['name']=$tdata['name'];
		$map['password']=pass_encrypt($tdata['password']);
		$is_true=\app\index\model\User::where($map)->field('id,is_effect')->select();
		if($is_true[0]['id']==''){
			$data =['type' =>1,'msg' =>'账号或密码错误,请重新输入!'];
			return json($data);
		}
		
		if($is_true[0]['is_effect']!=1){
			$data =['type' =>1,'msg' =>'该账号已停用，请联系网站管理员!'];
			return json($data);
		}
		
		Session::set('USER_ID',$is_true[0]['id']);
		Session::delete('sms_phone');
		Session::delete('sms_rand');
		$data =['type' =>'ok','msg' =>'登录成功!'];
		return json($data);
		
    }	
	
	//注册操作
    public function insert(){
		IS_AJAX(Request::isAjax());
		$tdata=Request::param();

		$name=trim($tdata['name']);
		if(trim($tdata['name'])==''){
			$data =['type' =>1,'msg' =>'请填写用户名!'];
			return json($data);
		}		

		$is_name=\app\index\model\User::where('name',$name)->field('name')->find();
		if($is_name!=''){
			$data =['type' =>1,'msg' =>'该用户名已注册!'];
			return json($data);
		}

		if(preg_match("/([\x81-\xfe][\x40-\xfe])/",$name,$match)){
			$data =['type' =>1,'msg' =>'请使用3-12位英文、数字!'];
			return json($data);
		}

		if(strlen($name)<3 or strlen($name)>12) {
			$data =['type' =>1,'msg' =>'请使用3-12位英文、数字!'];
			return json($data);
		}

		$password=trim($tdata['password']);
		if($password==''){
			$data =['type' =>1,'msg' =>'请填写密码!'];
			return json($data);
		}
		
		$zw=preg_match("/([\x81-\xfe][\x40-\xfe])/",$password);
		$yw=preg_match("/^[A-Za-z]+$/",$password);
		$sz=preg_match("/^\d*$/",$password);
		if($zw or ($yw==1 or $sz==1) or strlen($password)<8 or strlen($password)>18){
			$data =['type' =>1,'msg' =>'请输入8-18位数字与字母的组合!','s'=>$zw,'ss'=>$yw,'sss'=>$sz];
			return json($data);
		}

		if($password!=$tdata['password1']){
			$data =['type' =>1,'msg' =>'密码与重复密码不一致!'];
			return json($data);
		}
		
		if($tdata['type']==2){
			if(trim($tdata['qyname'])==''){
				$data =['type' =>1,'msg' =>'请填写企业全称!'];
				return json($data);
			}
			if(trim($tdata['lxr'])==''){
				$data =['type' =>1,'msg' =>'请填写联系人姓名!'];
				return json($data);
			}
		}

		if(!filter_var($tdata['mail'], FILTER_VALIDATE_EMAIL)) {
			$data =['type' =>1,'msg' =>'请填写正确的邮箱地址!'];
			return json($data);
		}

		if(strlen($tdata['phone'])!="11" or is_numeric($tdata['phone'])==false) {
			$data =['type' =>1,'msg' =>'请填写正确的手机号码!'];
			return json($data);
		}
		
		$is_phone=\app\index\model\User::where('phone',$tdata['phone'])->field('phone')->find();
		if($is_phone!=''){
			$data =['type' =>1,'msg' =>'该手机号已注册!'];
			return json($data);
		}

		$sms_rand =Session::get('sms_rand');
		if(trim($tdata['code'])!=$sms_rand or trim($tdata['code'])==''){
			$data =['type' =>1,'msg' =>'短信验证码错误!'];
			return json($data);
		}
		
		$sms_phone=Session::get('sms_phone');		
		if(trim($tdata['phone'])!=$sms_phone){
			$data =['type' =>1,'msg' =>'错误操作001!'];
			return json($data);
		}
			
		//插入数据
		$id=\app\index\model\User::insert();
		//Session::set('USER_ID',$id);
		Session::delete('sms_phone');
		Session::delete('sms_rand');
		$data =['type' =>'ok','msg' =>'注册成功!'];
		return json($data);
    }
	
	//修改数据
	public function update(){
		IS_AJAX(Request::isAjax());
		$tdata=Request::param();
		$USER_ID=Session::get('USER_ID');
		if($USER_ID==''){
			$data =['type' =>1001,'msg' =>'未登录!'];
			return json($data);
		}

		if(!filter_var($tdata['mail'], FILTER_VALIDATE_EMAIL)) {
			$data =['type' =>1,'msg' =>'请填写正确的邮箱地址!'];
			return json($data);
		}
		
		$tdata['id']=$USER_ID;
		$user=\app\index\model\User::strict(false)->update($tdata);
		$data =['type' =>'ok','msg' =>'修改成功!'];
		return json($data);
	}


	//修改密码
	public function password_update(){
		IS_AJAX(Request::isAjax());
		$tdata=Request::param();
		$USER_ID=Session::get('USER_ID');
		if($USER_ID==''){
			$data =['type' =>1001,'msg' =>'未登录!'];
			return json($data);
		}

		if(trim($tdata['pass0'])==''){
			$data =['type' =>1,'msg' =>'请填写原始密码!'];
			return json($data);
		}

		$password=trim($tdata['password']);
		if($password==''){
			$data =['type' =>1,'msg' =>'请填写密码!'];
			return json($data);
		}
		
		$zw=preg_match("/([\x81-\xfe][\x40-\xfe])/",$password);
		$yw=preg_match("/^[A-Za-z]+$/",$password);
		$sz=preg_match("/^\d*$/",$password);
		if($zw or ($yw==1 or $sz==1) or strlen($password)<8 or strlen($password)>18){
			$data =['type' =>1,'msg' =>'请输入8-18位数字与字母的组合!','s'=>$zw,'ss'=>$yw,'sss'=>$sz];
			return json($data);
		}

		
		if(trim($tdata['pass1'])==''){
			$data =['type' =>1,'msg' =>'请确认密码!'];
			return json($data);
		}

		$user=\app\index\model\User::find($USER_ID);
		$pass0=pass_encrypt($tdata['pass0']);
		if($pass0!=$user['password']){
			$data =['type' =>1,'msg' =>'原始密码错误!'];
			return json($data);
		}

		if($tdata['password']!=$tdata['pass1']){
			$data =['type' =>1,'msg' =>'新密码与确认密码不一致!'];
			return json($data);
		}

		$tdata['id']=$USER_ID;
		$tdata['password']=pass_encrypt($tdata['password']);
		$user=\app\index\model\User::strict(false)->update($tdata);
		$data =['type' =>'ok','msg' =>'修改成功!'];
		return json($data);
	}

	//找回密码
	public function password_back(){
		IS_AJAX(Request::isAjax());
		$tdata=Request::param();

		if(trim($tdata['name'])==''){
			$data =['type' =>1,'msg' =>'请填写用户名!'];
			return json($data);
		}

		if(trim($tdata['mail'])==''){
			$data =['type' =>1,'msg' =>'请填写邮箱!'];
			return json($data);
		}

		if(trim($tdata['phone'])==''){
			$data =['type' =>1,'msg' =>'请填写手机号!'];
			return json($data);
		}
				
		$password=trim($tdata['password']);
		if($password==''){
			$data =['type' =>1,'msg' =>'请填写密码!'];
			return json($data);
		}
		
		$zw=preg_match("/([\x81-\xfe][\x40-\xfe])/",$password);
		$yw=preg_match("/^[A-Za-z]+$/",$password);
		$sz=preg_match("/^\d*$/",$password);
		if($zw or ($yw==1 or $sz==1) or strlen($password)<8 or strlen($password)>18){
			$data =['type' =>1,'msg' =>'请输入8-18位数字与字母的组合!','s'=>$zw,'ss'=>$yw,'sss'=>$sz];
			return json($data);
		}
		
		if(trim($tdata['password1'])==''){
			$data =['type' =>1,'msg' =>'请确认密码!'];
			return json($data);
		}

		if($tdata['password']!=$tdata['password1']){
			$data =['type' =>1,'msg' =>'密码不一致!'];
			return json($data);
		}
		
		$map['name']=$tdata['name'];
		$map['mail']=$tdata['mail'];
		$map['phone']=$tdata['phone'];
		$is_true=\app\index\model\User::where($map)->select();
		
		if($is_true[0]==''){
			$data =['type' =>1,'msg' =>'信息不匹配!'];
			return json($data);exit;
		}
		
		$pass['id']=$is_true[0]['id'];
		$pass['password']=pass_encrypt($tdata['password']);
		$user=\app\index\model\User::strict(false)->update($pass);
		$data =['type' =>'ok','msg' =>'修改成功!'];
		return json($data);
	}
	//退出登录
	public function out(){
		Session::delete('USER_ID');
		return redirect('/login.html');
	}		

}