<?php
namespace app\index\model;
use think\Model;

// 引入框架内置类
use think\facade\Db;
use think\facade\Event;
use think\facade\Session;
use think\facade\Request;

class Form extends Model{
	
    // 定义时间戳字段名
    protected $createTime = 'create_time';
    protected $updateTime = 'update_time';

	//前端录入信息
	public static function insert(){
		$tdata=Request::param();
		
		if($tdata['table']=='form_content4'){
			$tdata['ly19']=json_encode($tdata['ly19']);
			$tdata['ly20']=json_encode($tdata['ly20']);
		}
		
		$tdata['create_time']=time();
		$tdata['userid']=Session::get('USER_ID');
		$id=Db::name($tdata['table'])->strict(false)->insertGetId($tdata);
		return $id;
	}
	
	//获取list
	public static function form_list($table){
		$info=Db::name('form_content')->where('phone',$id)->find();
		return $info;
	}
		
	//获取info
	public static function form_info($id){
		$info=Db::name('form_content')->where('phone',$id)->find();
		return $info;
	}

	//上下条 待用其他新页面详情翻页
	public static function page($time){
		$y=date('Y',$time);
		
		$n_1=strtotime(date(''.$y.'-01-01 00:00:00'));
        $n_2=strtotime(date(''.$y.'-12-31 23:59:59'));

		$map1[] = ['create_time','>=',$n_1];
		$map1[] = ['create_time','<=',$n_2];
		$map1[] = ['create_time','>',$time];
		$list1=Db::name('form_content')->where($map1)->order('create_time desc')->limit(1)->select();

		$map2[] = ['create_time','>=',$n_1];
		$map2[] = ['create_time','<=',$n_2];
		$map2[] = ['create_time','<',$time];
		$list2=Db::name('form_content')->where($map2)->order('create_time desc')->limit(1)->select();
		
		if($list1[0]['id']==''){
			$page['title1']='没有了!';
			$page['url1']='#this';
		}else{
			$page['title1']=$list1[0]['zpmc'];
			$page['url1']='/PreviousWorks/view/'.$list1[0]['id'].'.html';
		}

		if($list2[0]['id']==''){
			$page['title2']='没有了!';
			$page['url2']='#this';
		}else{
			$page['title2']=$list2[0]['zpmc'];
			$page['url2']='/PreviousWorks/view/'.$list2[0]['id'].'.html';
		}

		return $page;
	}

}