<?php
namespace app\index\model;
use think\Model;

// 引入框架内置类
use think\facade\Db;
use think\facade\Event;
use think\facade\Session;
use think\facade\Request;

class Lists extends Model{
	
    // 定义时间戳字段名
    protected $createTime = 'create_time';
    protected $updateTime = 'update_time';

	//lists页面数据
	public static function list_page($id,$model_id,$limit){
		
		$get_id_array=get_index_cate_id_son($id);//获取所有下级栏目
		$get_id_array=get_index_id_array_filter($get_id_array,$model_id);//去除属于其他模型的栏目,获得真实pid_array
		
		$table=tq_value($model_id,'table','cate_type');
		$order=tq_value($id,'is_sort','cate');
		
		$tdata=Request::param();

		$map = [];
		$map[] = ['is_effect','=',1];
		$map[] = ['is_delete','=',1];
		$map[] = ['pid','in',$get_id_array];
		
		//if(isset($tdata['city'])){
		if(!empty($tdata['title'])){
			//$map[] = ['title','=',$tdata['title']];
			$map[] = ['title','like','%'.$tdata['title'].'%'];
		}
		
		$list =Db::name('article')->alias('a')->join('article_'.$table.' c', 'a.id=c.aid', 'left')->field('a.*,c.*')->where($map)
			  ->order('sort '.$order.',create_time desc')->paginate(['list_rows' =>$limit,'query' => request()->param(),]);
		
		return $list;
	}

	//单独获取文章列表信息 C5
	public static function list_article($id,$limit,$model_id,$att){
		
		$get_id_array=get_index_cate_id_son($id);//获取所有下级栏目
		$get_id_array=get_index_id_array_filter($get_id_array,$model_id);//去除属于其他模型的栏目,获得真实pid_array
		
		$table=tq_value($model_id,'table','cate_type');
		$order=tq_value($id,'is_sort','cate');

		$map = [];
		$map[] = ['is_effect','=',1];
		$map[] = ['is_delete','=',1];
		if($att!=''){
			$map[] = ['att','like','%'.$att.'%'];
		}
		$map[] = ['pid','in',$get_id_array];
		
		$list =Db::name('article')->alias('a')->join('article_'.$table.' c', 'a.id=c.aid', 'left')->field('a.*,c.*')->where($map)
			  ->order('sort '.$order.',create_time desc')->limit($limit)->select()->toArray();

		foreach($list as $k=>$c){
			if($c['link']!=''){
				$list[$k]['url']=$c['link'];
			}else{
				$list[$k]['url']=info_seo_url($c['pid'],$c['id']);
			}
		}
		
		return $list;
	}
	
}